<?php
error_reporting(0);

//Incluir Archivos Necesarios
require_once './Clases/db.php';

//Verificar si el usuario ha iniciado sesion 
session_start();
if (!isset($_SESSION['Username'])) { 
  header("Location: index.php");
  exit;
}

?>
<!DOCTYPE html>
<html>
<head>
    <link rel="icon" type="image/png" href="Imagenes/logo.png">
    <title>Administrador</title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!--======== Boostrap / CSS / Boostrap Icons / Datatables ========-->
    <link rel="stylesheet" type="text/css" href="./bootstrap-5.3.1/css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="./ArchivosCSS/style_indexs.css">
    <link rel="stylesheet" type="text/css" href="./bootstrap-icons-1.10.5/font/bootstrap-icons.css">
    <link rel="stylesheet" type="text/css" href="./DataTables/datatables.min.css">
</head>
<body>
    <!--========  nav ========-->
    <div class="sidebar-nav">
        <nav class="navbar navbar-dark bg-primary fixed-top">
          <div class="container">

            <!--##:: Boton para abrir el menu lateral ::##-->
            <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasNavbar" aria-controls="offcanvasNavbar">
                <span class="navbar-toggler-icon"></span>
            </button>

            <!--##:: Opciones del menu lateral ::##-->
            <div class="bg-dark offcanvas offcanvas-start shadow" tabindex="-1" id="offcanvasNavbar" aria-labelledby="offcanvasNavbarLabel">
               <div class="offcanvas-body">
                 <ul class="navbar-nav">
                    <li>
                        <a href="02_IndexVendedor.php"><i class="bi bi-house-door-fill"></i> Inicio
                        </a>
                    </li>

                    <li class="nav-item dropdown w-100">
                       <a  class="nav-link dropdown-toggle text-light pl-4" id="navbarDropdown" role="button" data-toggle="dropdown" aria-expanded="false"><i class="bi bi-boxes"></i> Inventario
                       </a>

                       <ul class="dropdown-menu w-100" aria-labelledby="navbarDropdown">

                          <li>
                            <a href="./vendedor/productos.php" 
                            class="dropdown-item  pl-4 p-2"><i class="bi bi-box-seam"></i> Ver Productos
                        </a>
                    </li>
                </ul>
            </li>

            <li class="nav-item dropdown w-100">
              <a href="#" class="nav-link dropdown-toggle text-light pl-4" id="navbarDropdown" role="button" data-toggle="dropdown" aria-expanded="false"><i class="bi bi-bag-fill"></i> Ventas
              </a>

              <ul class="dropdown-menu w-100" aria-labelledby="navbarDropdown">
               <li>
                   <a href="./vendedor/ventas.php" class="dropdown-item  pl-4 p-2"><i class="bi bi-cash-coin"></i> Generar Ventas
                   </a>
               </li>
               <li>
                   <a href="./vendedor/consultar_ventas.php" class="dropdown-item  pl-4 p-2"><i class="bi bi-search"></i> Consultar Ventas 
                   </a>
               </li>
               <li>
                   <a href="./vendedor/tasadolar.php" class="dropdown-item  pl-4 p-2"><i class="bi bi-coin"></i> Tasa del Dolar 
                   </a>
               </li>
           </ul>
       </li>
       <li>
        <a href="./vendedor/cliente.php"> 
            <span class="item-text"><i class="bi bi-search"></i>Consultar Clientes</span>
        </a>
    </li>
    <li>
        <a href="./vendedor/datos_personales.php"> 
            <span class="item-text"><i class="bi bi-person-lines-fill"></i>Registrar Cliente / Proveedor</span>
        </a>
    </li>
</ul><!--FIN DE <ul class="navbar-nav">--> 
</div><!--FIN DE <div class="offcanvas-body">--> 
</div><!--FIN DE <div class="bg-dark offcanvas">--> 

   <!--##:: Opciones del usuario en el nav ::##-->
   <div class="btn-group">
     <a href="#" class="dropdown-toggle text-white text-decoration-none" data-bs-toggle="dropdown" aria-expanded="false">
         <span class="textnone"><i class="bi bi-person-circle"></i> Bienvenido <?php echo $_SESSION['Username'];?>!</span>
     </a>

     <!--<ul class="bg-light dropdown-menu dropdown-menu-end">-->
       <ul class="dropdown-menu dropdown-menu dropdown-menu-end">
           <!--##:: Formulario de control de Opciones del usuario ::##-->
                   <form method="POST" action="salir.php">
                    <li>
                        <button class="dropdown-item" type="submit" name=""><i class="bi bi-power"></i> Salir
                        </button>
                    </li>
                </form>

    </ul><!--FIN DE <ul class="dropdown-menu dropdown-menu dropdown-menu-end">--> 
    </div><!--FIN DE <div class="btn-group">--> 
    </div><!--FIN DE div Container--> 
</nav><!--FIN DE <nav class="navbar navbar-dark bg-primary fixed-top">-->
</div><!--FIN DE div SiderNav-->

<!--======== Main ========-->
<div class="main">
    <div class="interno">
        <div class="row">
            <div class="card text-bg-secondary mb-3 m-3" style="max-width: 14rem;">
                <div class="card-body ">
                  <div class="col">
                     <h5 class="card-title" style="text-align: center;">NUMERO DE VENTAS DEL DIA</h5>
                     <i class="bi bi-cart4" style="font-size: 40px; display: flex; justify-content: center; align-items: center;">
                       <?php
                       require_once './Clases/Reporte.php';
                       $mostrar = new reportes();
                       $result = $mostrar->ventas_dia(); 
                       echo $result; ?>
                   </i>
               </div>
           </div>
     </div>
     <div class="card text-bg-warning mb-3 m-3" style="max-width: 14rem;">
          <div class="card-body">
            <div class="col">
                <h5 class="card-title" >DINERO DEL DIA</h5>
                <i class="bi bi-cash-coin" style="font-size: 40px; display: flex; justify-content: center; align-items: center;">
                  $<?php
                  require_once './Clases/Reporte.php';
                  $mostrar = new reportes ();
                  $result = $mostrar->dinero_dia(); 
                  echo $result; ?>

              </i>
          </div>
      </div>
</div>
<div class="card text-bg-success mb-3 m-3" style="max-width: 14rem;">
      <div class="card-body">
        <div class="col">
            <h5 class="card-title" style="text-align: center;">TASA DEL DIA  <a class="tasad" href="./Opciones_menu/tasadolar.php">
                <i class="bi bi-plus-circle" style="font-size: 20px; display: flex; justify-content: center; align-items: center;"></i></a></h5>
            <i class="bi bi-currency-dollar" style="font-size: 40px; display: flex; justify-content: center; align-items: center;">
                <?php

                require_once './Clases/Tasa.php';
                $mostrar = new tasas ();
                $result = $mostrar->multiplicartasa(); 
                echo $result; ?></i>
            </div>
        </div>
</div>
<div class="card text-bg-info mb-3 m-3" style="max-width: 14rem;">
   <div class="card-body">
     <div class="col">
        <h6 class="card-title" style="text-align: center;">PRODUCTOS VENDIDOS </h6>
        <i class="bi bi-p-circle-fill" style="font-size: 40px; display: flex; justify-content: center; align-items: center;">
          <?php
            require_once './Clases/Reporte.php';
            $mostrar = new reportes ();
            $result = $mostrar->productos_dia(); 
            echo $result; 
          ?>
      </i>
  </div>
</div>
</div>
<div class="card text-bg-danger mb-3 m-3" style="max-width: 14rem;">
    <div class="card-body">
      <div class="col">
        <h5 class="card-title" style="text-align: center; font-size: 14px;">CANTIDAD DE PRODUCTOS CON STOCK BAJO</h5>
        <i class="bi bi-bell-fill" style="font-size: 40px; display: flex; justify-content: center; align-items: center;">
          <?php
          require_once './Clases/Reporte.php';
          $mostrar = new reportes ();
          $result = $mostrar->stock_bajo(); 
          echo $result; ?>
      </i>
  </div>
</div>
</div>
</div>

<div class="row"> 
    <H4>Tabla de productos con stock menor a 10 unidades</H4>
    <?php
        require_once './Clases/Reporte.php';
        $mostrar = new reportes ();
        $productos = $mostrar->productostockbajo(); 
    ?>
    <table id="myTable" class="table table-dark table-striped ">
        <thead>
            <tr>
                <td>Cod</td>
                <td>Nombre</td>
                <td>Stock</td>
            </tr>
        </thead>
        <tbody>
         <?php foreach ($productos as $producto) { ?>
            <tr>
                <td><?php echo $producto['Cod']; ?></td>
                <td><?php echo $producto['Nombre']; ?></td>
                <td><?php echo $producto['Stock_Actual']; ?></td>
            </tr>
        <?php } ?>
    </tbody>
</table>
</div> <!-- Fin div del row table -->
</div><!--##:: Fin Divinterno ::##-->
</div><!--##:: Fin DivMain ::##-->

<!--======== Jquery / bootstrap.bundle / bootstrap.min / Datatable ========-->
<script src="./ArchivosJS/jquery-3.6.0.min.js"></script> 
<script src="./bootstrap-5.3.1/js/bootstrap.bundle.min.js"></script>
<script src="./ArchivosJS/bootstrap.min.js"></script>
<script src="./DataTables/datatables.min.js"></script>
<script type="text/javascript">
    $(document).ready( function () {
        $('#myTable').DataTable({
            language: {
                processing:     "Tratamiento en curso...",
                search:         "Buscar:" ,
                lengthMenu:    "Filtro de _MENU_ producto",
                info:           "Mostrando del producto _START_ al _END_ de un total de _TOTAL_ productos",
                infoEmpty:      "No existen registros",
                infoFiltered:   "(filtrado de _MAX_ producto en total)",
                infoPostFix:    "",
                loadingRecords: "Cargando elementos...",
                zeroRecords:    "No se encontraron los datos de tu busquda..",
                emptyTable:     "No hay ningun registro en la tabla",
                paginate: {
                    first:      "Primero",
                    previous:   "Anterior",
                    next:       "Siguiente",
                    last:       "Ultimo"
                },
                aria: {
                    sortAscending:  ": Active para odernar en modo ascendente",
                    sortDescending: ": Active para ordenar en modo descendente  ",
                }
            }
        } );
    } );
</script>
<footer class="footer">
<p>&copy; Todos los derechos reservados - <?php echo date("Y"); ?> | La Emperadora Internet Y Mas</p>
</footer>
</body>
</html>