<?php
error_reporting(0);

//Incluir Archivos Necesarios
require_once './Clases/db.php';
require_once './Clases/Producto.php';

//Verificar si el usuario ha iniciado sesion 
session_start();
if (!isset($_SESSION['Username'])) { 
  header("Location: index.php");
  exit;
}

$mostrar = new productos ();
$productos = $mostrar->getAllproducto();

?>
<!DOCTYPE html>
<html>
<head>
    <link rel="icon" type="image/png" href="Imagenes/logo.png">
    <title>Clientes</title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!--======== Boostrap / CSS / Boostrap Icons / Datatables ========-->
    <link rel="stylesheet" type="text/css" href="./bootstrap-5.3.1/css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="./ArchivosCSS/style_indexs.css">
    <link rel="stylesheet" type="text/css" href="./bootstrap-icons-1.10.5/font/bootstrap-icons.css">
    <link rel="stylesheet" type="text/css" href="./DataTables/datatables.min.css">
</head>
<body>

    <!--========  nav ========-->
    <div class="sidebar-nav">
        <nav class="navbar navbar-dark bg-primary fixed-top" style="height:10%;">
          <div class="container">
            <div></div>
            <!--##:: Opciones del usuario en el nav ::##-->
            <div class="btn-group">
             <a href="#" class="dropdown-toggle text-white text-decoration-none" data-bs-toggle="dropdown" aria-expanded="false">
                 <span class="textnone"><i class="bi bi-person-circle"></i>  Bienvenido <?php echo $_SESSION['Username'];?>  ! </span>
             </a>
             <!--<ul class="bg-light dropdown-menu dropdown-menu-end">-->
               <ul class="dropdown-menu dropdown-menu dropdown-menu-end">
                   <!--##:: Formulario de control de Opciones del usuario ::##-->
                   <form method="POST" action="salir.php">
                    <li>
                        <button class="dropdown-item" type="submit" name=""><i class="bi bi-power"></i> Salir
                        </button>
                    </li>
                </form>
            </ul><!--FIN DE <ul class="dropdown-menu dropdown-menu dropdown-menu-end">--> 
            </div> 
        </div><!--FIN DE div Container--> 
    </nav>
</div><!--FIN DE div SiderNav-->
    
    <!--======== Main ========-->
    <div class="main">
        <div class="interno" >
            <h1>Lista de productos</h1>
            <table id="myTable" class="table table-dark table-striped ">
                <thead>
                    <tr>
                        <td>Img</td>
                        <td>Cod</td>
                        <td>Nombre</td>
                        <td>Descripcion</td>
                        <td>Stock</td>
                        <td>Precio Venta</td>
                        <td>Precio V en Bs</td>
                    </tr>
                </thead>
                <tbody>
                 <?php foreach ($productos as $producto) { ?>
                    <tr>
                        <td> <a href="#!" data-bs-toggle="modal" data-bs-target="#modalImage<?php echo $producto['Cod']; ?>">
                          <img class="img-thumbnail" width="50" height="70" src="./Imagenes/<?php echo $producto['Imagen']; ?>"></a></td>
                          <td><?php echo $producto['Cod']; ?></td>
                          <td><?php echo $producto['Nombre']; ?></td>
                          <td><?php echo $producto['Descripcion']; ?></td>
                          <td><?php echo $producto['Stock_Actual']; ?></td>
                          <td>$<?php echo $producto['Precio_Venta']; ?></td>
                          <td> Bs <?php $preciov = $producto['Precio_Venta']; 
                          require_once './Clases/Tasa.php';
                          $mostrar = new tasas ();
                          $result = $mostrar->multiplicartasa(); 

                          $preciobs = $preciov * $result; 
                          echo $preciobs;
                          ?>
                      </td>
                  </tr>
                  <div tabindex="-1" arial-labelledby="modalImage" aria-hidden="true" class="modal fade" id="modalImage<?php echo $producto['Cod']; ?>">
                      <div class="modal-dialog  modal-dialog-centered">
                        <div class="modal-content">
                          <img class="img-thumbnail" src="./Imagenes/<?php echo $producto['Imagen']; ?>">
                      </div>
                  </div>
              </div>     
          <?php } ?>
      </tbody>
  </table>

</div><!--##:: Fin Divinterno ::##-->
</div><!--##:: Fin DivMain ::##-->

<!--======== Jquery / bootstrap.bundle / bootstrap.min / Datatable ========-->
<script src="./ArchivosJS/jquery-3.6.0.min.js"></script> 
<script src="./bootstrap-5.3.1/js/bootstrap.bundle.min.js"></script>
<script src="./ArchivosJS/bootstrap.min.js"></script>
<script src="./DataTables/datatables.min.js"></script>

<script type="text/javascript">
    $(document).ready( function () {
        $('#myTable').DataTable({
            language: {
                processing:     "Tratamiento en curso...",
                search:         "Buscar:" ,
                lengthMenu:    "Filtro de _MENU_ producto",
                info:           "Mostrando del producto _START_ al _END_ de un total de _TOTAL_ productos",
                infoEmpty:      "No existen registros",
                infoFiltered:   "(filtrado de _MAX_ producto en total)",
                infoPostFix:    "",
                loadingRecords: "Cargando elementos...",
                zeroRecords:    "No se encontraron los datos de tu busquda..",
                emptyTable:     "No hay ningun registro en la tabla",
                paginate: {
                    first:      "Primero",
                    previous:   "Anterior",
                    next:       "Siguiente",
                    last:       "Ultimo"
                },
                aria: {
                    sortAscending:  ": Active para odernar en modo ascendente",
                    sortDescending: ": Active para ordenar en modo descendente  ",
                }
            }
        } );
    } );
</script>
<footer class="footer">
<p>&copy; Todos los derechos reservados - <?php echo date("Y"); ?> | La Emperadora Internet Y Mas</p>
</footer>
</body>
</html>