<?php
//error_reporting(0);

//Incluir Archivos Necesarios
require_once '../Clases/db.php';
require_once '../Clases/Usuario.php';

//Verificar si el usuario ha iniciado sesion 
session_start();
if (!isset($_SESSION['Username'])) { 
  header("Location: ../index.php");
  exit;
}

$mostrar = new Usuarios();
$usuarios = $mostrar->getAllusuarios();

//############# TOASTS ############//
include "../ArchivosCSS/StyleToasts.php";
?>

<!DOCTYPE html>
<html lang="es">
<header>
    <title>Administrar Usuarios</title>
    <link rel="stylesheet" type="text/css" href="../ArchivosCSS/Toast_Position.css">
</header>
<body>
    <!--======== Incluir Menu Lateral y Nav ========-->
    <?php  include 'menu_lateral.php'; ?>

    <!--======== Main ========-->
    <div class="main">
        <div class="interno" >
           <!--======== Area Toast ========-->
           <div class="contenedor-toasts-internos" id="contenedor-botones"> 
              <?php
              if(isset($_GET["Add_user"])==1){

                //toast de exito registro correcto
                  echo $exitoADD;
                  echo $exitoToastADD;
              }
              if(isset($_GET["Update_user"])==1){
                //toast de exito edicion correcta
                  echo $exitoEDIT;
                  echo $exitoToastEDIT;
              }
              if(isset($_GET["Delete_user"])==1){

                //toast de exito Eliminacion correcta
                  echo $exitoDELETE;
                  echo $exitoToastDELETE;
              }
              if(isset($_GET["Restaurar_user"])==1){

                //toast de exito Restauracion correcta
                  echo $exitoRESTAURAR;
                  echo $exitoToastRESTAURAR;
              }
              if(isset($_GET["error"])==1){

                //toast de  error " No estan permitidos los caracteres especiales en el usuario."
                  echo $errorBTN1;
                  echo $errorToast1;
              }     
              if(isset($_GET["error"])==2){

                //toast de  error " Usuario en uso, intente con otro usuario"
                  echo $errorBTN2;
                  echo $errorToast2;
              }            
              if(isset($_GET["campos_vacios"])==1){

                //toast de error no puede dejar campos vacios
                echo $errorBTN6;
                echo $errorToast6;
              }
              ?>
          </div>
          <!--======== Fin Area Toast ========-->
          <div class="breadcrumb-holder">                                             
                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#Registrar_Usuarios">
                    <i class="bi bi-pencil-square"></i> Registrar Usuarios
                </button> <?php  include('Modales/Usuarios/modal_usuarios.php'); ?>
          </div><br>

          <table id="myTable" class="table table-dark table-striped ">
            <thead>
                <tr>
                    <td>ID</td>
                    <td>Username</td>
                    <td>Correo</td>
                    <td>Rol de usuario</td>
                    <td>Fecha</td>
                    <td>Acciones</td>                    
                </tr>
            </thead>
            <tbody>
               <?php foreach ($usuarios as $usuario) { ?>
                <tr>
                    <td><?php echo $usuario['ID']; ?></td>
                    <td><?php echo $usuario['Username']; ?></td>
                    <td><?php echo $usuario['Correo']; ?></td>
                    <td><?php echo $usuario['Perfil_User']; ?></td>
                    <td><?php echo $usuario['Fecha']; ?></td>
                    <td>
                        <button type="button" data-bs-toggle="modal" data-bs-target="#editar<?php echo $usuario['ID']; ?>" 
                            class="btn btn-warning btn-sm"><i class="bi bi-pencil-square"></i>
                        </button>
                        <button type="button" data-bs-toggle="modal" data-bs-target="#eliminar<?php echo$usuario['ID']; ?>"
                            class="btn btn-danger btn-sm"><i class="bi bi-trash-fill"></i>
                        </button>
                    </td>
                </tr>
                <?php  include('Modales/Usuarios/modal_usuarios.php'); ?>
            <?php } ?>
        </tbody>
    </table>

    <div class="breadcrumb-holder">                                             
      <button type="button" class="btn btn-secondary" data-bs-toggle="modal" data-bs-target="#userseliminados">
         <i class="bi bi-eye-fill"></i> Ver Usuarios Eliminados
        </button> <?php  include('./Modales/Usuarios/usuarioseliminado.php'); ?>
     </div><hr> 
     <div class="breadcrumb-holder" >                                             
      <a class= "btn btn-warning" href="./controladores/Usuarios/reportes.php" target="_blank"><i class="bi bi-file-earmark-pdf-fill"></i>REPORTE TOTAL</a>

  </div>
  <form action="./controladores/Usuarios/formato.php" method="post">
    <div class="row"> <h5>Reporte por Rol de Usuarios</h5>

        <div class="col-lg-3">

              <select class="form-select" aria-label="Default select example" name="perfil" id="perfil" required>
                <option></option>
                <option value="1">Administrador</option>
                <option value="2">Vendedor</option>
                <option value="3">Cliente</option>
              </select>
           
   </div>

   <div class="col-lg-4">
    <button type="submit" value="Imprimir" class="btn btn-success">Imprimir Reporte <i class="bi bi-printer-fill"></i></button>
</div>
<div class="col-lg-1"></div>
</form>
 </div><!--##:: Fin Divinterno ::##-->
</div><!--##:: Fin Main ::##-->

<!--======== Jquery / bootstrap.bundle / bootstrap.min / Datatable / Toast ========-->
<script src="../ArchivosJS/jquery-3.6.0.min.js"></script> 
<script src="../bootstrap-5.3.1/js/bootstrap.bundle.min.js"></script>
<script src="../ArchivosJS/bootstrap.min.js"></script>
<script src="../DataTables/datatables.min.js"></script>
<script src="../ArchivosJS/toasts.js"></script>

<!--======== Funcion para restaurar registros ========-->
<script type="text/javascript">
  $(document).ready(function() {
     $('.btnRestaurar').click(function(e){

        e.preventDefault();
        var IDE = $(this).attr("ID");

        var dataString = 'ID='+ IDE;
        url = "./controladores/Usuarios/restaurar_user.php";
        $.ajax({
            type: "POST",
            url: url,
            data: dataString,
            success: function(data)
            {
              window.location.href="Administrar_Usuarios.php?Restaurar_user=1";
              $('#respuesta').html(data);
          }
      });
        return false;
        
    });
 });
</script>
<script type="text/javascript">
    $(document).ready( function () {
        $('#myTable').DataTable({
            language: {
                processing:     "Tratamiento en curso...",
                search:         "Buscar:" ,
                lengthMenu:    "Filtro de _MENU_ usuarios",
                info:           "Mostrando del usuario _START_ al _END_ de un total de _TOTAL_ usuarios",
                infoEmpty:      "No existen registros",
                infoFiltered:   "(filtrado de _MAX_ usuario en total)",
                infoPostFix:    "",
                loadingRecords: "Cargando elementos...",
                zeroRecords:    "No se encontraron los datos de tu busquda..",
                emptyTable:     "No hay ningun registro en la tabla",
                paginate: {
                    first:      "Primero",
                    previous:   "Anterior",
                    next:       "Siguiente",
                    last:       "Ultimo"
                },
                aria: {
                    sortAscending:  ": Active para odernar en modo ascendente",
                    sortDescending: ": Active para ordenar en modo descendente  ",
                }
            }
        } );
    } );
</script>
<footer class="footer">
    <p>&copy; Todos los derechos reservados - <?php echo date("Y"); ?> | La Emperadora Internet Y Mas</p>
</footer>
</body>
</html>