<?php
require_once '../Clases/db.php';
require_once '../Clases/Venta.php';
require_once '../Clases/Producto.php';
require_once '../Clases/Reporte.php';
//Verificar si el usuario ha iniciado sesion 
session_start();
if (!isset($_SESSION['Username'])) { 
  header("Location: ../index.php");
exit;
}
//############# TOASTS ############//
include "../ArchivosCSS/StyleToasts.php";

?>
<!DOCTYPE html>
<html lang="es">
<header>
        <title>Estadisticas</title>
        <link rel="stylesheet" type="text/css" href="../ArchivosCSS/Toast_Position.css">
</header>
<body>
    <!--======== Incluir Menu Lateral y Nav ========-->
     <?php  include 'menu_lateral.php'; ?>

 <!--##:: Main ::##-->
<div class="main">

    <div class="interno" >
  <!--======== Area Toast ========-->
           <div class="contenedor-toasts-internos" id="contenedor-botones"> 
              <?php
              
              if(isset($_GET["error"])==1){

                //toast de error no puede dejar campos vacios
                echo $errorBTN6;
                echo $errorToast6;
              }
              ?>
          </div>
          <!--======== Fin Area Toast ========-->
                    <div class="row"> <h5>Consultar los 5 Productos mas Vendidos por Rango de Fecha</h5>
                       <div class="col-lg-1"></div>
                        <div class="col-lg-3">
                            <input type="date"  class="form-control" name="txtfecha1" id="txtfecha1" required/>
                        </div>
                        <div class="col-lg-3">
                            <input type="date" class="form-control" name="txtfecha2" id="txtfecha2" required/>
                        </div>
                        <div class="col-lg-4">
                            <button type="submit"  class="btn btn-primary" onclick="CargarDatosGrafico()">Buscar</button>
                        </div>
                        <div class="col-lg-1"></div>
                    </div>
                    <hr>
              
       
            
              <canvas id="myChart"></canvas>
         
      
    </div><!--##:: Fin Divinterno ::##-->
</div><!--##:: Fin DivMain ::##-->
   
     <footer class="footer">
        <p>&copy; Todos los derechos reservados - <?php echo date("Y"); ?> | La Emperadora Internet Y Mas</p>
     </footer>
    <!--##::Link boostrap JS offline::##-->
    <script src="../bootstrap-5.3.1/js/bootstrap.bundle.min.js"></script>
    <script src="../ArchivosJS/jquery-3.6.0.min.js"></script> 
    
    <script src="../ArchivosJS/bootstrap.min.js"></script>
    <script src="../DataTables/datatables.min.js"></script>
<script src="../ArchivosJS/toasts.js"></script>
<script src="../ArchivosJS/chart.umd.js"></script>
   <script>


   function CargarDatosGrafico() { 


    var fechainicio= $("#txtfecha1").val();
 var fechafin= $("#txtfecha2").val();

if (fechainicio === "" || fechafin === "") {
    window.location.href="estadisticas.php?error=1";
    return false;
  } else { 
  
  

 var chart = Chart.getChart("myChart");
    if (chart) {
        chart.destroy();
    }
        $.ajax ({
          url: './controladores/grafico/controlador_grafico.php',
          type: 'POST',
          data: {
            inicio:fechainicio,
            fin:fechafin

          }
         
        }) .done(function(resp){
         var nombre = [];
          var cantidad = [];
      
         var data = JSON.parse(resp) ;
       


         for (var i=0; i <data.length; i++){ 
          nombre.push(data[i].Nom_produc);
          cantidad.push(data[i].cantidad);
         
     
          

          }
    const ctx = document.getElementById('myChart');

  new Chart(ctx, {
    type: 'bar',
     data: {
      labels: nombre, 
      datasets: [{
        label: 'Cantidad Vendida',
        data: cantidad,
        
       
        backgroundColor: ['#CB4335', '#1F618D', '#F1C40F', '#27AE60', '#884EA0', '#D35400','#B1B0B0 '],
        borderWidth: 1
      }]
    },
    options: {
      scales: {
        y: {
          beginAtZero: true
        }
      }
    }
     })
     })
  }
       
          }

</script>
 </body>
</html>