<?php   
require("../../modelos/Jugador/Jugador.php");
session_start();
$jugador = new Jugador; //Creamos nuestro objeto
 $op = isset($_GET["op"]) ? limpiarCadena($_GET["op"]) : ""; // $_GET
 $id_numero = isset($_POST["id_numero"]) ? limpiarCadena($_POST["id_numero"]) : "";
 $cartonId = isset($_POST["cartonId"]) ? limpiarCadena($_POST["cartonId"]) : "";

$al_id_bingo = isset($_POST["al_id_bingo"]) ? limpiarCadena($_POST["al_id_bingo"]) : "";
//Verificar si el usuario ha iniciado sesion 
 if (!isset($_SESSION['_AL_id_bingo'])) { 
    header('Location: '.$rutaBase.'login.php?Acceso_No_Permitido');
    exit;
}
$id_usuario = $_SESSION['_AL_id_bingo'];
//======================================================================================================//
    //Definicion de todas las variables


//======================================================================================================//

switch ($op){

case 'listar':
    $busqueda = isset($_GET['busqueda']) ? intval($_GET['busqueda']) : null;
    $rspta = $jugador->listarinactivo($busqueda);
    $cartones = [];
    while ($row = $rspta->fetch_assoc()) {
        $cartones[$row['carton_id']][] = $row; // Agrupar por carton_id       
    }

    $html = '<div class="row">'; // Abre la fila principal

    foreach ($cartones as $carton_id => $numeros) {
        $html .= '
        <div class="col-md-3 mb-3"> <!-- Añadir margen inferior para separación -->
        <div class="card card-widget">
        <div class="card-header d-flex justify-content-between align-items-center">
        <h3 class="card-title">N° de Carton: ' . htmlspecialchars($carton_id) . '</h3>

        <button type="button" onclick="elegirCarton(' . htmlspecialchars(json_encode($carton_id)) . ', ' . htmlspecialchars(json_encode($id_usuario)) . ')" class="btn btn-primary btn-sm">
        <i class="fas fa-check "></i> Elegir
        </button>
        </div>
        <table id="carton" class="table table-bordered">
        <thead>
        <tr>
        <th class="b">B</th>
        <th class="i">I</th>
        <th class="n">N</th>
        <th class="g">G</th>
        <th class="o">O</th>
        </tr>
        </thead>
        <tbody>';
        
        // Inicializar un contador para números
        $count = 0;
        foreach ($numeros as $numero) {
            // Si hemos llegado a 5 números, cerrar la fila y abrir una nueva
            if ($count % 5 == 0) {
                if ($count > 0) { // No cerrar una fila antes de añadir el primer número
                    $html .= '</tr>'; // Cerrar la fila anterior
                }
                $html .= '<tr>'; // Iniciar una nueva fila
            }

            if ($numero['numero'] == 0) {
    $html .= '<td><button type="button" class="btn btn-default numero-grande" disabled>
                <i class="fa-solid fa-star"></i>
              </button></td>';
} else {
                // Agregar el botón correspondiente cuando el número es diferente de 0
                $botonColor = $numero['marcado'] == 1 ? 'btn-success' : 'btn-default';
                $estado = $numero['estado']; // Asegúrate de que 'estado' viene de tu array

                // Verificar si el estado es INACTIVO
                $disabled = ($estado == 'INACTIVO') ? 'disabled' : '';

                $html .= '<td>
                <button type="button" class="btn ' . $botonColor . ' numero-grande" id="btn-' . 
                htmlspecialchars($numero['id']) . '" onclick="marcar(' . 
                htmlspecialchars($numero['id']) . ')" ' . $disabled . '>
                ' . htmlspecialchars($numero['numero']) . '
                </button>
                </td>';
            }

            $count++; // Incrementar el contador
        }

        // Cerrar la última fila si hay algún número
        if ($count > 0) {
            $html .= '</tr>'; // Asegurarse de cerrar la fila final
        }
        
        $html .= '    </tbody>
        </table>
        </div>
            </div>'; // Cierra el div del cartón
    }

    $html .= '</div>'; // Cierra la fila principal
    echo json_encode(["status" => "success", "html" => $html]);

    break;

case 'listaractivo':
    $rspta = $jugador->listaractivo($id_usuario);
    $cartones = [];
    while ($row = $rspta->fetch_assoc()) {
        $cartones[$row['carton_id']][] = $row; // Agrupar por carton_id       
    }

    $html = '<div class="row">'; // Abre la fila principal

    foreach ($cartones as $carton_id => $numeros) {
        $html .= '
        <div class="col-md-3 mb-3"> <!-- Añadir margen inferior para separación -->
        <div class="card card-widget">
        <div class="card-header d-flex justify-content-between align-items-center">
        <h3 class="card-title">N° de Carton: ' . htmlspecialchars($carton_id) . '</h3>
        <button type="button" onclick="eliminarcarton(' . htmlspecialchars(json_encode($carton_id)) . ', ' . htmlspecialchars(json_encode($id_usuario)) . ')" class="btn btn-danger btn-sm">
            <i class="fas fa-xmark"></i> Eliminar
        </button>
        </div>
        <table id="carton" class="table table-bordered">
        <thead>
        <tr>
        <th class="b">B</th>
        <th class="i">I</th>
        <th class="n">N</th>
        <th class="g">G</th>
        <th class="o">O</th>
        </tr>
        </thead>
        <tbody>';
        
        // Inicializar un contador para números
        $count = 0;
        foreach ($numeros as $numero) {
            // Si hemos llegado a 5 números, cerrar la fila y abrir una nueva
            if ($count % 5 == 0) {
                if ($count > 0) { // No cerrar una fila antes de añadir el primer número
                    $html .= '</tr>'; // Cerrar la fila anterior
                }
                $html .= '<tr>'; // Iniciar una nueva fila
            }

            // Verificar si el número es 0
            if ($numero['numero'] == 0) {
                $html .= '<td><button type="button" class="btn btn-default numero-grande" disabled>
                <i class="fa-solid fa-star"></i>
              </button></td>'; // Mostrar el ícono
            } else {
                // Si no es 0, continuar con el botón
                $botonColor = $numero['marcado'] == 1 ? 'btn-success' : 'btn-default';
                $estado = $numero['estado']; // Asegúrate de que 'estado' viene de tu array
                $disabled = ($estado == 'INACTIVO') ? 'disabled' : '';

                $html .= '<td>
                <button type="button" class="btn ' . $botonColor . ' numero-grande" id="btn-' . htmlspecialchars($numero['id_numero_carton']) . '" onclick="marcar(' . htmlspecialchars($numero['id_numero_carton']) . ')" ' . $disabled . '>
                ' . htmlspecialchars($numero['numero']) . '
                </button>
                </td>';
            }

            $count++; // Incrementar el contador
        }

        // Cerrar la última fila si hay algún número
        if ($count > 0) {
            $html .= '</tr>'; // Asegurarse de cerrar la fila final
        }
        
        $html .= '</tbody>
        </table>
        </div>
        </div>'; // Cierra el div del cartón
    }

    $html .= '</div>'; // Cierra la fila principal
    echo json_encode(["status" => "success", "html" => $html]);

    break;

case 'listarhistorial':
$rspta = $jugador->listarhistorial($id_usuario );
$cartones = [];
while ($row = $rspta->fetch_assoc()) {
    $cartones[$row['carton_id']][] = $row; // Agrupar por carton_id       
}

$html = '<div class="row">'; // Abre la fila principal

foreach ($cartones as $carton_id => $numeros) {
    $html .= '
    <div class="col-md-3 mb-3"> <!-- Añadir margen inferior para separación -->
    <div class="card card-widget">
    <div class="card-header d-flex justify-content-between align-items-center">
    <h3 class="card-title">N° de Carton: ' . htmlspecialchars($carton_id) . '</h3>
 
    </div>
    <table id="carton" class="table table-bordered">
    <thead>
    <tr>
    <th class="b">B</th>
    <th class="i">I</th>
    <th class="n">N</th>
    <th class="g">G</th>
    <th class="o">O</th>
    </tr>
    </thead>
    <tbody>';
    
    // Inicializar un contador para números
    $count = 0;
    foreach ($numeros as $numero) {
        // Si hemos llegado a 5 números, cerrar la fila y abrir una nueva
        if ($count % 5 == 0) {
            if ($count > 0) { // No cerrar una fila antes de añadir el primer número
                $html .= '</tr>'; // Cerrar la fila anterior
            }
            $html .= '<tr>'; // Iniciar una nueva fila
        }


         if ($numero['numero'] == 0) {
    $html .= '<td><button type="button" class="btn btn-default numero-grande" disabled>
                <i class="fa-solid fa-star"></i>
              </button></td>';
}else {
   // Agregar el botón dentro del td
        $botonColor = $numero['marcado'] == 1 ? 'btn-success' : 'btn-default';
$estado = $numero['estado']; // Asegúrate de que 'estado' viene de tu array

// Verificar si el estado es INACTIVO
$disabled = ($estado == 'INACTIVO') ? 'disabled' : '';

$html .= '<td>
<button type="button" class="btn ' . $botonColor . ' numero-grande" id="btn-' . htmlspecialchars($numero['id_numero_carton']) . '" onclick="marcar(' . htmlspecialchars($numero['id_numero_carton']) . ')" disabled>
' . htmlspecialchars($numero['numero']) . '
</button>
</td>';
}

        $count++; // Incrementar el contador
    }

    // Cerrar la última fila si hay algún número
    if ($count > 0) {
        $html .= '</tr>'; // Asegurarse de cerrar la fila final
    }
    
    $html .= '    </tbody>
    </table>
    </div>
        </div>'; // Cierra el div del cartón
    }

$html .= '</div>'; // Cierra la fila principal
echo json_encode(["status" => "success", "html" => $html]);

break;

case 'mostrarestadisticas':
    $rspta=$jugador->mostrarestadisticas($al_id_bingo);
    //Codificar el resultado utilizando json
    echo json_encode($rspta);
    break;
    


case 'marcado':
$rspta=$jugador->cambiarmarcado($id_numero);
echo $rspta;
break;


case 'elegir':
$rspta=$jugador->guardarelegido($cartonId,$id_usuario);
echo $rspta ? "Carton Elegido Correctamente" : "ERROR: Debes comprar este carton para esta partida";

break;

case 'eliminarcarton':
$rspta=$jugador->eliminarelegido($cartonId,$id_usuario);
echo $rspta ? "Carton Eliminado Correctamente" : "ERROR: No se pudo eliminar";

break;



       case 'obtenerultimaurl':
$rspta=$jugador->obtenerurl();

        echo json_encode($rspta);//Retornar el resultado utilizando json
        break;

        
}// FIN switch
?>