<?php 
require_once "global.php";

$conexion = new mysqli(DB_HOST,DB_USERNAME,DB_PASSWORD,DB_NAME);

mysqli_query($conexion, 'SET NAMES "'.DB_ENCODE.'"');

//Si tenemos un posible error en la conexión lo mostramos
if (mysqli_connect_errno())
{
	printf("Falló conexión a la base de datos: %s\n",mysqli_connect_error());
	exit();
}

if (!function_exists('ejecutarConsulta'))
{
	//Consulta #1 Consulta Normal
	function ejecutarConsulta($sql)
	{
		global $conexion;
		$query = $conexion->query($sql);
		return $query;
	}

	//Consulta #2 Consulta Simple
	function ejecutarConsultaSimpleFila($sql)
	{
		global $conexion;
		$query = $conexion->query($sql);		
		$row = $query->fetch_assoc();
		return $row;
	}

	//Consulta #3 retorna ID
	function ejecutarConsulta_retornarID($sql)
	{
		global $conexion;
		$query = $conexion->query($sql);		
		return $conexion->insert_id;			
	}

	  function ejecutarConsultaMultipleFilas($sql)
{
    global $conexion;
    $query = $conexion->query($sql);
    $result = [];
    
    while ($row = $query->fetch_assoc()) {
        $result[] = $row; // Agregar cada fila al arreglo de resultados
    }
    
    return $result; // Devolver todas las filas
}

//funcin til para obtener rpidamente un nico dato de la base de datos
	function ejecutarConsultaSimpleValor($sql)
    {
     global $conexion;
     $query = $conexion->query($sql);
     $row = $query->fetch_row();
     return $row[0];
   }

	//Limpiar Cadena de texto
	function limpiarCadena($str)
	{
		global $conexion;
		$str = mysqli_real_escape_string($conexion,trim($str));
		return htmlspecialchars($str);
	}

	//Limpiar numeros (para formatear campos con numeros "funcion Nueva")
	function limpiarNumero($numero) {
    	//Eliminar todas las comas 
    	$numeroLimpio = str_replace(',', '', $numero);
    
    	// Verificar si hay un punto decimal y si hay ms de un punto
    	if (strpos($numeroLimpio, '.') !== false) {
        	$partes = explode('.', $numeroLimpio);
        	if (count($partes) > 2) {
            	//Si hay ms de un punto, tomar solo las dos primeras partes
            	$numeroLimpio = implode('.', array_slice($partes, 0, 2));
        	}
    	}
    	return $numeroLimpio;
	}
	
	//mostrar valores numericos con dos decimales (1,00)
	function muestrafloat($monto){
  		return number_format($monto, 2, ',', '.');
	}
}
?>