<?php
//Incluir la conexion a la base de datos
require("../../config/Conexion.php");

class Administrador
{
	//Definicion de todas las variables
  
    var $id_numero;
    var $cartonId;
    var  $id_usuario;
    var $numero;
    var $letra; 
	//constructor
    public function __construct(){
    }

//--------------------------------------------------------------------------------//

	
//--------------------------------------------------------------------------------//



public function generarCarton() {
    $carton = [];
    $rangos = [
        range(1, 15),
        range(16, 30),
        range(31, 45),
        range(46, 60),
        range(61, 75)
    ];

    // Mezclar cada rango para garantizar aleatoriedad
    foreach ($rangos as &$rango) {
        shuffle($rango);
    }

    // Crear el cartón con 25 números únicos, excepto en la fila 3, columna 2
    $fila = 0;
    for ($i = 0; $i < 5; $i++) {
        for ($j = 0; $j < 5; $j++) {
            $fila++;
            if ($fila === 3 && $j === 1) { // Condición para la fila 3, columna 2
                $carton[] = null;
            } else {
                $carton[] = array_shift($rangos[$j]);
            }
        }
    }

    return $carton;
}



public function generarYGuardarCartones() {
    $cartonesGenerados = [];

    for ($i = 0; $i < 1000; $i++) {
        do {
            $nuevoCarton = $this->generarCarton(); // Generar nuevo cartón
            $uniqueKey = implode(",", $nuevoCarton);
        } while (in_array($uniqueKey, $cartonesGenerados));

        $cartonesGenerados[] = $uniqueKey;
        
        // Guardar el cartón en la base de datos
        $carton_id = $i + 1; // Asumiendo que el id comienza desde 1
        
        foreach ($nuevoCarton as $numero) {
            $q = "INSERT INTO bingo_cartones(carton_id, numero) VALUES ('$carton_id', '$numero')";
            $rspta = ejecutarConsulta($q); // Ejecutar consulta
            
            // Opcional: Manejo de errores si es necesario
            if (!$rspta) {
                // Maneja el error (puedes lanzar una excepción o registrar el error)
            }
        }
    }
    return $rspta; // Retornar éxito al finalizar
}


 public function cambiarmarcado($id_numero) {
    // Actualizar marcado a 0 si ya es 1, de lo contrario, lo cambia a 1
    $q = "UPDATE bingo_cartones SET marcado = IF(marcado = '1', '0', '1') WHERE id = '$id_numero'"; 

    $rspta = ejecutarConsulta($q); // Ejecutar consulta

    // Verificar si se realizó el cambio
    if ($rspta) {
        // Obtener el nuevo estado
        $nuevo_marcado = $this->obtenerMarcado($id_numero);
        return $nuevo_marcado ? "Numero marcado" : "Numero desmarcado"; // Cambiar el mensaje de respuesta
    }
    return "No se pudo marcar";
}

// Función para obtener el estado actual del 'marcado'
private function obtenerMarcado($id_numero) {
    $q = "SELECT marcado FROM bingo_cartones WHERE id = '$id_numero'";
    $result = ejecutarConsultaSimpleFila($q); // Asume que tienes una función para ejecutar y obtener un solo resultado
    return $result['marcado'] == '1';
}

public function enviarurl($url)
{
    
        // Insertar el número y la letra en numeros_cantados con el id_partida
        $q = "INSERT INTO videos (video_url) VALUES ('$url')";
        
        $rspta = ejecutarConsulta($q); // Ejecutar consulta
        return $rspta;
     
}

public function listar(){

        $q = "SELECT id, usuario,nombre
              FROM usuario
              WHERE estado_conectado = 1";

       //die($q);
       $rspta = ejecutarConsulta($q);//Ejecutar consulta
       return $rspta; 
    }
    
    public function ValidarPartida() {
    // Obtener el ID de la partida activa
    $q = "SELECT estado FROM partidas  ORDER BY id DESC LIMIT 1";
//die($q);
$rspta = ejecutarConsulta($q);
return $rspta;
}

public function guardarelegido($cartonId, $id_usuario) {
    // Consulta para insertar en la tabla usuario_carton
    $q = "INSERT INTO usuario_carton (id_carton, id_usuario) VALUES ('$cartonId', '$id_usuario')";
    
    // Ejecutar consulta de inserción
    $rspta = ejecutarConsulta($q);
    
    // Verificar si la inserción fue exitosa antes de continuar
    if ($rspta) {
        // Consulta para actualizar el estado en bingo_cartones
        $q1 = "UPDATE bingo_cartones SET estado = 'ACTIVO' WHERE carton_id = '$cartonId'";
        
        // Ejecutar consulta de actualización
        $rspta = ejecutarConsulta($q1);
        
        return $rspta; // Retorna el resultado de la actualización
    }
    
    return false; // Retorna false si la inserción falla
}

public function EmpezarPartida($fecha) {
    // Consulta para insertar en la tabla usuario_carton
    $q = "INSERT INTO partidas (fecha_inicio, estado) VALUES ('$fecha', 1)";
    
    // Ejecutar consulta de inserción
    $rspta = ejecutarConsulta($q);

   if ($rspta) {    
    // Obtener el ID del último registro insertado
    $sql = "SELECT id FROM partidas WHERE estado = 1 ORDER BY id DESC LIMIT 1";    
    $id_partida = ejecutarConsultaSimpleValor($sql); 

    $q = "INSERT INTO numeros_cantados (numero,id_partida) VALUES (0,'$id_partida')";
    $rspta = ejecutarConsulta($q); // Ejecutar consulta
     return $rspta; // Retorna el resultado de la actualización
    }
   return false;
       
}


public function FinalizarPartida($fecha) {
    // Obtener el último id de la tabla partidas con estado 1
    $q = "SELECT id FROM partidas WHERE estado = 1 ORDER BY id DESC LIMIT 1";
    $id_partida = ejecutarConsultaSimpleValor($q);

    // Verificar si se obtuvo un id de partida
    if (!$id_partida) {
        return false; // No hay partida activa
    }

    // Actualizar el estado de la partida activa a 0
    $q = "UPDATE partidas SET estado = 0, fecha_finalizada = '$fecha' WHERE id = $id_partida";

    // Ejecutar consulta de actualización
    $rspta = ejecutarConsulta($q);

    if ($rspta) {
        // Actualizar el estado de los cartones
        // Marcar todos como INACTIVO
        $q2 = "UPDATE bingo_cartones SET estado = 'INACTIVO', marcado = 
               CASE 
                   WHEN numero = 0 THEN '1' 
                   ELSE '0' 
               END
               WHERE estado = 'ACTIVO'";
        $rspta2 = ejecutarConsulta($q2);
    }

    return isset($rspta2) ? $rspta2 : $rspta; // Retorna el resultado de la actualización o de la partida
}


public function enviarNumeroYLetra($numero, $letra)
{
    // Obtener el último id de la tabla partidas con estado 1
    $q = "SELECT id FROM partidas WHERE estado = 1 ORDER BY id DESC LIMIT 1";
    $id_partida = ejecutarConsultaSimpleValor($q);

    // Verificar si existe una partida activa
    if (!$id_partida) {
        return "Aún no hay partida iniciada";
    }
    

    // Verificar si el número y la letra ya existen en numeros_cantados para la partida actual
    $q = "SELECT COUNT(*) FROM numeros_cantados WHERE numero = '$numero' AND letra = '$letra' AND id_partida = '$id_partida'";
    $existe = ejecutarConsultaSimpleValor($q);

    // Si existe, retornar un mensaje
    if ($existe > 0) {
        return "El número y letra ya existen en la partida actual";
    }

    // Insertar el número y la letra en numeros_cantados si no existen
    $q = "INSERT INTO numeros_cantados (numero, letra, id_partida) VALUES ('$numero', '$letra', '$id_partida')";
    $rspta = ejecutarConsulta($q); // Ejecutar consulta
     // Verificar si la inserción fue exitosa
    if ($rspta) {
        return "Número Enviado Correctamente";
    } else {
        return "Error al insertar el número y letra";
    }
}

public function MostrarTodos_LosNumeros_Cantados() //En la partida actual
{

    // Obtener el ID de la partida activa
    $q = "SELECT id FROM partidas WHERE estado = 1 ORDER BY id DESC LIMIT 1";
    $id_partida_activa = ejecutarConsultaSimpleValor($q);

    // Seleccionar todos los números cantados para la partida activa y ordenarlos
  $q = "SELECT id, numero, letra FROM numeros_cantados WHERE id_partida = '$id_partida_activa' AND id <> (SELECT MAX(id) FROM numeros_cantados WHERE id_partida = '$id_partida_activa') AND numero <> 0  ";
    $rspta = ejecutarConsulta($q);

    return $rspta;
}

public function MostrarNumerosCantados()
{

    // Obtener el ID de la partida activa
    $q = "SELECT id FROM partidas WHERE estado = 1 ORDER BY id DESC LIMIT 1";
    $id_partida_activa = ejecutarConsultaSimpleValor($q);

    // Seleccionar todos los números cantados para la partida activa y ordenarlos
  $q = "SELECT id, numero, letra 
FROM numeros_cantados 
WHERE id_partida = '$id_partida_activa' AND numero <> 0 
ORDER BY id DESC 
LIMIT 1;
";
    $rspta = ejecutarConsulta($q);

    return $rspta;
}


public function listarcartonganador() {
    $q = "  SELECT 
    bc.carton_id AS carton_id, 
    bc.numero AS numero, 
    bc.estado AS estado, 
    bc.id AS id, 
    bc.marcado AS marcado,
    uc.id_usuario AS id_usuario, 
    u.usuario AS username,
    (SELECT MAX(id_partida) FROM numeros_cantados) AS id_partida
FROM bingo_cartones bc 
JOIN usuario_carton uc ON bc.carton_id = uc.id_carton  
JOIN usuario u ON uc.id_usuario = u.id  
JOIN ( 
    SELECT carton_id 
    FROM bingo_cartones
    WHERE estado = 'ACTIVO' AND marcado = '1' 
    GROUP BY carton_id 
    HAVING COUNT(*) = 25 
) AS subquery ON bc.carton_id = subquery.carton_id
JOIN ( 
    SELECT numero 
    FROM numeros_cantados 
    WHERE id_partida = (SELECT MAX(id_partida) FROM numeros_cantados)
) AS nc ON bc.numero = nc.numero  
WHERE  
    bc.estado = 'ACTIVO' 
    AND uc.id = (SELECT MAX(id) FROM usuario_carton WHERE id_carton = bc.carton_id)";

    // Ejecutar la consulta
    $rspta = ejecutarConsulta($q);
   
   
    // Comprobar si hay resultados
    if (mysqli_num_rows($rspta) > 0) {
        return $rspta; // Retorna los resultados si hay al menos un cartón ganador    
    } else {
        return []; // Retorna un array vacío si no hay cartones ganadores    
    }
}

public function MarcarGanador($cartonId, $id_partida, $id_usuario_ganador)
{
    // Consulta para verificar si 'gano' ya es 1
    $checkQuery = "SELECT gano FROM compras_cartones WHERE id_jugador = '$id_usuario_ganador' AND id_partida = '$id_partida' AND carton_id = '$cartonId'";
    $checkResult = ejecutarConsultaSimpleValor($checkQuery);

    if ($checkResult == 1) {
        return false;
    }
    // Si no es un ganador, proceder con el update
    $q = "UPDATE compras_cartones SET
          gano = 1
          WHERE id_jugador = '$id_usuario_ganador' AND id_partida = '$id_partida' AND carton_id = '$cartonId'";

    $rspta = ejecutarConsulta($q); // Ejecutar consulta
    return $rspta;
}
    
       public function listarhistorialpartida() {
    $q = "
SELECT 
    A.id, 
    A.fecha_inicio, 
    A.fecha_finalizada, 
    A.estado, 
    A.ganador, 
    GROUP_CONCAT(CONCAT(U.usuario, ' (', C.carton_id, ')') SEPARATOR ', ') AS ganadores
FROM 
    partidas A
LEFT JOIN 
    compras_cartones C ON A.id = C.id_partida AND C.gano = 1 -- Filtramos solo cartones ganadores en el JOIN
LEFT JOIN 
    usuario U ON C.id_jugador = U.id 
GROUP BY 
    A.id -- Agrupamos solo por partida para mantener todos los ganadores en la misma fila
ORDER BY 
    A.fecha_inicio DESC";

    $rspta = ejecutarConsulta($q); // Ejecutar consulta
    return $rspta; 
}

}//Fin de la clase
?>