<?php
//Incluir la conexion a la base de datos
require("../../config/Conexion.php");

class Jugador
{
	//Definicion de todas las variables

    var $id_numero;
    var $cartonId;
    var  $id_usuario;

	//constructor
    public function __construct(){
    }

    public function listarinactivo($busqueda) {
    // Construimos la consulta base
    $q = "SELECT * FROM bingo_cartones WHERE estado = 'INACTIVO'";

    // Verificamos si hay un valor en $busqueda
    if (!empty($busqueda)) {
        $q .= " AND carton_id = '$busqueda'";
    }

    $q .= " LIMIT 200"; // Limitamos la consulta a 200 registros

    // Ejecutar la consulta
    $rspta = ejecutarConsulta($q);
    return $rspta;
}


public function listaractivo($id_usuario) {
    $q = "SELECT DISTINCT bc.carton_id as carton_id, 
                         bc.numero as numero, 
                         bc.estado as estado, 
                         bc.id as id_numero_carton, 
                         bc.marcado as marcado 
          FROM bingo_cartones bc 
          JOIN usuario_carton uc ON bc.carton_id = uc.id_carton
          WHERE uc.id_usuario = '$id_usuario' 
          AND bc.estado = 'ACTIVO'
          LIMIT 200";
    
    $rspta = ejecutarConsulta($q); // Ejecutar consulta    
    return $rspta;
}

   

public function cambiarmarcado($id_numero) {
    // Actualizar marcado a 0 si ya es 1, de lo contrario, lo cambia a 1
    $q = "UPDATE bingo_cartones SET marcado = IF(marcado = '1', '0', '1') WHERE id = '$id_numero'"; 
//die($q); exit;
    $rspta = ejecutarConsulta($q); // Ejecutar consulta

    // Verificar si se realizó el cambio
    if ($rspta) {
        // Obtener el nuevo estado
        $nuevo_marcado = $this->obtenerMarcado($id_numero);
        return $nuevo_marcado ? "Numero marcado" : "Numero desmarcado"; // Cambiar el mensaje de respuesta
    }
    return "No se pudo marcar";
}

// Función para obtener el estado actual del 'marcado'
private function obtenerMarcado($id_numero) {
    $q = "SELECT marcado FROM bingo_cartones WHERE id = '$id_numero'";
    $result = ejecutarConsultaSimpleFila($q); // Asume que tienes una función para ejecutar y obtener un solo resultado
    return $result['marcado'] == '1';
}

public function guardarelegido($cartonId, $id_usuario) {
    // Obtener el máximo 'id' para la partida
    $sql = "SELECT MAX(id) as id FROM partidas";    
    $rspta1 = ejecutarConsultaSimpleValor($sql);  
    
    // Aumentar el valor obtenido en 1
    $partida = $rspta1 + 1;

    // Consulta para verificar si el carton y el jugador están registrados
    $sql = "SELECT * FROM compras_cartones WHERE id_jugador = '$id_usuario' AND carton_id = '$cartonId' AND id_partida = '$partida'";

    $respuesta = ejecutarConsultaSimpleFila($sql);

    // Verificar si hay resultados
    if (!empty($respuesta)) {
    
        // Consulta para insertar en la tabla usuario_carton
        $q = "INSERT INTO usuario_carton (id_carton, id_usuario) VALUES ('$cartonId', '$id_usuario')";
         //die($q); exit;
        // Ejecutar consulta de inserción
        $rspta = ejecutarConsulta($q);
   
        // Verificar si la inserción fue exitosa antes de continuar
        if ($rspta) {
            // Consulta para actualizar el estado en bingo_cartones
            $q1 = "UPDATE bingo_cartones SET estado = 'ACTIVO' WHERE carton_id = '$cartonId'";
            
            // Ejecutar consulta de actualización
            $rspta2 = ejecutarConsulta($q1);
            return $rspta2;  // Retornar el resultado de la actualización
           
        }
        return false;  // Retornar false si la inserción falló
    } else {
        // Si no hay resultados, retornar un mensaje de error o realizar alguna otra acción
        return false;
    }
}

public function eliminarelegido($cartonId, $id_usuario) {
    // Consulta para actualizar el estado en bingo_cartones
    $q = "UPDATE bingo_cartones 
SET estado = 'INACTIVO', 
    marcado = CASE 
                  WHEN numero = 0 THEN marcado -- No cambia el valor si numero es 0
                  ELSE '0' -- Cambia a '0' si numero no es 0
               END 
WHERE carton_id = '$cartonId'";
    
    // Ejecutar consulta de actualización
    $rspta = ejecutarConsulta($q);
    
    // Verificar si la actualización fue exitosa antes de continuar
    if ($rspta) {
        // Consulta para eliminar el último registro en usuario_carton
        $q1 = "DELETE FROM usuario_carton 
                WHERE id = (
                    SELECT MAX(id) 
                    FROM usuario_carton 
                    WHERE id_usuario = '$id_usuario' AND id_carton = '$cartonId'
                )";
        
        // Ejecutar consulta de eliminación
        $rspta2 = ejecutarConsulta($q1);
        
        return $rspta2; // Retorna el resultado de la eliminación
    }
    
    return false; // Retorna false si la actualización falla
}

public function obtenerurl()
{
    
        $q = "SELECT id, video_url FROM videos ORDER BY id DESC LIMIT 1 ";
        
        $rspta = ejecutarConsultaSimpleFila($q); // Ejecutar consulta
        return $rspta;
     
}

  public function listarhistorial($id_usuario) {
    $q = "SELECT DISTINCT bc.carton_id as carton_id, 
                         bc.numero as numero, 
                         bc.estado as estado, 
                         bc.id as id_numero_carton, 
                         bc.marcado as marcado 
          FROM bingo_cartones bc 
          JOIN usuario_carton uc ON bc.carton_id = uc.id_carton
          WHERE uc.id_usuario = '$id_usuario' 
          AND bc.estado = 'INACTIVO'
          LIMIT 1600";
    
    $rspta = ejecutarConsulta($q); // Ejecutar consulta    
    return $rspta;
}

public function mostrarestadisticas($id_usuario)
{
    $q = "
        SELECT 
            COUNT(*) AS total_cartones, 
            COUNT(DISTINCT id_partida) AS total_partidas,
            COUNT(DISTINCT CASE WHEN gano = 1 THEN id_partida END) AS total_partidas_ganadas
        FROM 
            compras_cartones 
        WHERE 
            id_jugador = '$id_usuario'
    ";
    // die($q);
    $rspta = ejecutarConsultaSimpleFila($q); // Ejecutar consulta
    return $rspta;
}


}//Fin de la clase
?>