
function init() {


    $("#formularioREG_EDIT").on("submit", function(e) {
        e.preventDefault(); // Evita el envío del formulario por defecto
        guardaryeditar(e);
    });
    //================================================================//
    ValidarPartida();
getNumerosAll();

    //================================================================//
}


function limpiarenvionumero()
{

  $("#numero").val("");
  $("#letra").val("");

}

function limpiaractualizador()
{

  $("#url").val("");

}

function listarjugador() {
    // Guardar la referencia de la tabla
    var tabla = $('#datatable').DataTable({
        language: {
            processing: "Tratamiento en curso...",
            search: "Buscar:",
            lengthMenu: "Filtro de _MENU_ registros",
            info: " Total de Usuarios _TOTAL_ ",
            infoEmpty: "No existen registros",
            infoFiltered: "(filtrado de _MAX_ registros en total)",
            loadingRecords: "Cargando elementos...",
            zeroRecords: "No se encontraron los datos de tu búsqueda..",
            emptyTable: "No hay ningún registro en la tabla",
            paginate: {
                first: "Primero",
                previous: "Anterior",
                next: "Siguiente",
                last: "Último"
            },
            aria: {
                sortAscending: ": Active para ordenar en modo ascendente",
                sortDescending: ": Active para ordenar en modo descendente",
            }
        },
        buttons: [
            //'copyHtml5',
            'excelHtml5',
            'pdf'
        ],
        ajax: {
            url: '../../ajax/administrador/administrador.php?op=listarjugadoronline',
            dataType: "json",
            error: function (e) {
                // Manejo de errores si es necesario
            }
        },
        autoWidth: false,
        responsive: true,
        destroy: true,
        displayLength: 10,
        order: [
            [0, "asc"]
        ]
    });

    // Cambiar el setInterval para recargar cada 3 segundos
    setInterval(function() {
        tabla.ajax.reload(null, false); // false para evitar re-enfoque en la tabla
    }, 30000);
}

// Llamar a la función para iniciar
listarjugador();

//================================================================//



function generarcarton() {
    $.post("../../ajax/administrador/administrador.php?op=generarcarton&r=" + new Date().getTime(), {

    }, function(response) {
        // Al recibir respuesta del servidor

    });
}

function EmpezarPartida() {
    $.post("../../ajax/administrador/administrador.php?op=EmpezarPartida&r=" + new Date().getTime(), {
    }, function(response) {
        // Al recibir respuesta del servidor
        if (response == 'Partida Iniciada') { // Ajusta esto según la respuesta que esperas del servidor
            Swal.fire({
                icon: 'success',
                title: '¡Partida iniciada!',
                text: 'La partida se ha iniciado correctamente.',
                showConfirmButton: false,
            timer: 1300 // Tiempo antes de cerrar automáticamente
        }).then(() => {
            location.reload(); // Recargar la página
        });

    } else {
            // Manejar caso de error
        Swal.fire({
            icon: 'error',
            title: 'Oops...',
            text: 'Algo salió mal. Por favor, inténtalo de nuevo.'
        });
    }
});
}

function FinalizarPartida() {
    $.post("../../ajax/administrador/administrador.php?op=FinalizarPartida&r=" + new Date().getTime(), {
    }, function(response) {
        // Al recibir respuesta del servidor
        if (response == 'Partida Finalizada') { // Ajusta esto según la respuesta que esperas del servidor
            Swal.fire({
                icon: 'success',
                title: '¡Partida Finalizada!',
                text: '',
                showConfirmButton: false,
            timer: 1300 // Tiempo antes de cerrar automáticamente
        }).then(() => {
            location.reload(); // Recargar la página
        });

    } else {
            // Manejar caso de error
        Swal.fire({
            icon: 'error',
            title: 'Oops...',
            text: 'Algo salió mal. Por favor, inténtalo de nuevo.'
        });
    }
});
}

function enviarNumeroYLetra() {
    // Obtener los valores de los inputs
    var letra = document.getElementById('letra').value.trim().toUpperCase(); // Convertir a mayúscula
    var numero = document.getElementById('numero').value.trim();

    // Validar que los campos no estén vacíos
    if (letra === '' || numero === '') {
        Swal.fire({
            icon: 'warning',
            title: 'Campos Vacíos',
            text: 'Por favor, completa ambos campos.',
            showConfirmButton: true
        });
        return; // Salir de la función si la validación falla
    }

    // Validar que el número esté en el rango de 1 a 75
    if (numero < 1 || numero > 75) {
        Swal.fire({
            icon: 'error',
            title: 'Número fuera de rango',
            text: 'Por favor ingresa un número entre 1 y 75.',
            showConfirmButton: true
        });
        return; // Salir de la función si la validación falla
    }

    // Validar el rango correspondiente para cada letra
    if (
        (letra === 'B' && (numero < 1 || numero > 15)) ||
        (letra === 'I' && (numero < 16 || numero > 30)) ||
        (letra === 'N' && (numero < 31 || numero > 45)) ||
        (letra === 'G' && (numero < 46 || numero > 60)) ||
        (letra === 'O' && (numero < 61 || numero > 75))
    ) {
        Swal.fire({
            icon: 'error',
            title: 'Número y Letra no concuerdan',
            text: 'El número no es válido para la letra seleccionada.',
            showConfirmButton: true
        });
        return; // Salir de la función si la validación falla
    }

    $.ajax({
        url: '../../ajax/administrador/administrador.php?op=enviarNumeroYLetra&r=' + new Date().getTime(),
        method: 'POST',
        data: { numero: numero, letra: letra },
        success: function(response) {
            // Al recibir respuesta del servidor
            response = response.trim(); // Asegurarnos de que no hay espacios adicionales
            
            if (response === "Número Enviado Correctamente") {
                Swal.fire({
                    icon: 'success',
                    title: 'Número Enviado Correctamente',
                    text: '',
                    showConfirmButton: false,
                    timer: 1000 // Tiempo antes de cerrar automáticamente
                });
            } else if (response === "El número y letra ya existen en la partida actual") {
                Swal.fire({
                    icon: 'error',
                    title: 'Número y Letra Ya existe',
                    text: 'En la Partida Actual',
                    showConfirmButton: true,
                });
            } else if (response === "Aún no hay partida iniciada") {
                Swal.fire({
                    icon: 'info',
                    title: 'Partida No Iniciada',
                    text: 'Por favor, inicia una partida antes de enviar números y letras.',
                    showConfirmButton: true,
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'Por favor, inicia una partida antes de enviar números y letras.', // Muestra el mensaje de error recibido
                    showConfirmButton: true,
                });
            }

            limpiarenvionumero();
        }
    });
}

function getNumeros() {
    $.ajax({
        url: '../../ajax/administrador/administrador.php?op=listarnumeroscantados&r=' + new Date().getTime(),
        method: "GET",
        dataType: "json",
        success: function(numeros) {
            if (numeros.length > 0) {
                numeros.forEach(function(numero) {
                    var existingId = $('#contenedorbolas').find('.bola[data-id="' + numero[1] + '"]');

                    if (existingId.length === 0) {
                        // Crea el HTML para la bola con la imagen
                        var bolaHtml = '<div class="bola slide-in" data-id="' + numero[1] + '">' +
                                       '<img src="../../images/' + numero[2] + numero[0] + '.png" /> ' +
                                       '</div>';
                        $('#contenedorbolas').append(bolaHtml);
                    }
                });
            }
        }
    });
}

function ValidarPartida() {
    $.post("../../ajax/administrador/administrador.php?op=ValidarPartida&r=" + new Date().getTime(), {
        
    }, function(response) {
        // Al recibir respuesta del servidor
        if (response.trim() === "Ya existe una partida iniciada") {
          $("#btnEmpezar").prop("disabled", true);
           $("#btnFinalizar").prop("disabled", false);
        } else if (response.trim() === "Aun no hay partida iniciada") {
            // Cambiar el color del botón a secundario
          $("#btnFinalizar").prop("disabled", true);
           $("#btnEmpezar").prop("disabled", false);
        } else {
            alert('ERROR');
        }
    });
}

function getNumerosAll() {
    $.ajax({
        url: '../../ajax/administrador/administrador.php?op=listartodoslosnumeroscantados&r=' + new Date().getTime(),
        method: "GET",
        dataType: "json",
        success: function(numeros) {
            if (numeros.length > 0) {
                numeros.forEach(function(numero) {
                    var existingId = $('#contenedorbolas').find('.bola[data-id="' + numero[1] + '"]');

                    if (existingId.length === 0) {
                        $('#contenedorbolas').append('<div class="bola slide-in" data-id="' + numero[1] + '">' +
                                       '<img src="../../images/' + numero[2] + numero[0] + '.png" /> ' +
                                       '</div>');
                    }
                });
            }
        }
    });
}


        // Comprobación cada 5 segundos
setInterval(getNumeros, 3000);


//================================================================//
//mostrar el "formulario de registro (al hacer click)
function registrar(flag)
{
  mostrarform(true);//mostrar formulario 
  $("#statusdiv").hide(); //ocultar el campo status
  $("#btnGuardar").show(); //mostrar el boton de registrar
}



function Cancelarform()
{
  //limpiar();
  limpiarFormReg();
  mostrarform(false);//ocultar formulario registro
  mostrartable(true);
}

//================================================================//

function enviarURL() {
    // Obtener los valores de los inputs
    var url = document.getElementById('url').value;

    // Expresión regular para capturar el ID del video de YouTube
    var regex = /[?&]v=([^&#]*)/; // Esta regex busca el parámetro 'v' en la URL
    var match = url.match(regex);
    var videoId = match ? match[1] : null; // Obtiene el ID o null si no se encuentra

    if (videoId) {
        $.ajax({
            url: '../../ajax/administrador/administrador.php?op=enviarurl&r=' + new Date().getTime(),
            method: 'POST',
            data: { url: videoId }, // Enviamos solo el ID
            success: function(response) {
                Swal.fire({
                    icon: 'success',
                    title: 'URL Guardado Correctamente',
                    text: '',
                    showConfirmButton: false,
                    timer: 1000 // Tiempo antes de cerrar automáticamente
                });
                limpiaractualizador();  
            }
        });
    } else {
        Swal.fire({
            icon: 'error',
            title: 'URL Inválida',
            text: 'Por favor, introduce una URL de YouTube válida.',
            showConfirmButton: true
        });
    }
}

function listarcartonganador() {
    $.ajax({
        url: '../../ajax/administrador/administrador.php?op=listarcartonganador',
        dataType: 'json',
        success: function(response) {
            $('#tuContenedor').html(response.html);
        },
        error: function(xhr, status, error) {
            console.error('Error en la solicitud:', error);
            console.error('Detalles:', xhr.responseText);
        }
    });
}

function MarcarGanador(cartonId, id_partida, id_usuario) {
    $.ajax({
        url: '../../ajax/administrador/administrador.php?op=MarcarGanador',
        type: 'POST',
        data: { cartonId: cartonId, id_partida: id_partida, id_usuario: id_usuario },
        success: function(data) {
            // Verificar si el mensaje de éxito está presente en la respuesta
            if (data.includes("Ganador Elegido Correctamente")) {
                Swal.fire({
                    title: 'Resultado',
                    text: data,
                    icon: 'success',
                    showConfirmButton: false,
                    timer: 1300
                }).then(() => {
                    location.reload(); // Recargar la página
                });
            } else {
                // Mensaje de error si el cartón ya ha sido marcado como ganador
                Swal.fire({
                    title: 'Error',
                    text: "Este cartón ya ha sido marcado como ganador.",
                    icon: 'error',
                    confirmButtonText: 'Aceptar'
                });
            }
        },
        error: function(xhr, status, error) {
            Swal.fire({
                title: 'Error',
                text: "Error en la petición.",
                icon: 'error',
                confirmButtonText: 'Aceptar'
            });
        }
    });
}




init();