// Función que se ejecuta al inicio
function init() {
    mostrarform(false);//ocultar formulario de registro
    mostrartable(false);//ocultar table 
    listar();

    $("#formularioREG_EDIT").on("submit",function(e)
    {
        e.preventDefault(); //Evita el envío del formulario por defecto
        guardaryeditar(e);  
    });

//================================================================//
}


//Función limpiar (campos especificos en el formulario de registro)
function limpiarFormReg()
{
  $("#statusR").val("");
  $("#nombreR").val("");
  $("#apellidoR").val("");
  $("#correoR").val("");
  $("#passwordR").val("");
  $("#telefonoR").val("");
  $("#tipo_usuarioR").val("");
  //----------------------------------------//
  $("#usuarioR").val("");
  $("#usuarioR").removeClass("is-valid");
  $("#usuarioR").removeClass("is-invalid");
  //obtener el elemento message por su ID
  var messageElement = document.getElementById('messageR');
  messageElement.textContent = '';
}

//================================================================//
   

    function listar(){ 

        var tabla;
        tabla = $('#datatable').dataTable({
                language: {
                processing:     "Tratamiento en curso...",
                search:         "Buscar:" ,
                lengthMenu:    "Filtro de _MENU_ registros",
                info:           "Mostrando de _START_ al _END_ de un total de _TOTAL_ ",
                infoEmpty:      "No existen registros",
                infoFiltered:   "(filtrado de _MAX_ registros en total)",
                infoPostFix:    "",
                loadingRecords: "Cargando elementos...",
                zeroRecords:    "No se encontraron los datos de tu busquda..",
                emptyTable:     "No hay ningun registro en la tabla",
                paginate: {
                    first:      "Primero",
                    previous:   "Anterior",
                    next:       "Siguiente",
                    last:       "Ultimo"
                },
                aria: {
                    sortAscending:  ": Active para odernar en modo ascendente",
                    sortDescending: ": Active para ordenar en modo descendente  ",
                }
            },
            buttons: [
                //'copyHtml5',
                'excelHtml5',
                'pdf'
                ],

            "ajax": {
                url: '../../ajax/administrador/usuarios.php?op=buscar&r=' + new Date().getTime(),
                type: "POST",
                dataType: "json",
                error: function (e) {
                    //console.log(e.responseText);
                    //console.log("Error en la llamada AJAX:", e);
                    //alert("Error: " + e.responseText);
                }
            },
            "autoWidth": false,//hacer datatable responsive
            "responsive": true,//hacer datatable responsive
            "bDestroy": true,
            "iDisplayLength": 10, //Paginación
            "order": [
                [0, "asc"]
            ] //Ordenar (columna,orden)
        });
        mostrartable(true);//mostrar table 
    }
//================================================================//

//mostrar el "formulario de registro (al hacer click)
function registrar(flag)
{
  mostrarform(true);//mostrar formulario 
  $("#statusdiv").hide(); //ocultar el campo status
  $("#btnGuardar").show(); //mostrar el boton de registrar
  $("#passwordR").attr('required', 'required'); 

}

//================================================================//

//Funcion mostrar - ocultar formulario
function mostrarform(flag)
{
  //limpiar formularios
  limpiarFormReg();
  if (flag)
  {
 
    //entrando al formulario desde (el boton btnAgregar en la vista php)
    //$("#clavediv").show();//mostrar campo clave
    $("#titleLabel").text("Contraseña");
    $("#tabla").hide();//ocultar tabla
    $("#card_header").hide();
    $("#formularioregistros").show();
    $("#btnGuardar").prop("disabled",false);
    $("#btnagregar").hide();
  }
  else
  {
    $("#card_header").show();
    $("#formularioregistros").hide();//ocultar formulario registro
    $("#btnagregar").show();
  }
}

//================================================================//

//Función cancelar formulario registro
function Cancelarform()
{
  //limpiar();
  limpiarFormReg();
  $("#id_usuario").val("");
  mostrarform(false);//ocultar formulario registro
  mostrartable(true);
}

//================================================================//


//Evento se activa al cambiar el valor del input del campo usuario
$("#usuarioR").change(function(e) {
    e.preventDefault();

    var usuario = $("#usuarioR").val();//obtener value de la cedula

    //obtener el elemento message por su ID
    var messageElement = document.getElementById('messageR');


$.post("../../ajax/administrador/usuarios.php?op=validarUsuario&r=" + new Date().getTime(), {
    usuario: usuario
}).done(function(data) {
    // Actualizar el contenido del <span> con el mensaje recibido
    messageElement.textContent = '';

    //manejar respuestas
    if (data === "existe usuario") {
        messageElement.textContent = 'Este Usuario ya se encuentra registrado!';
        $("#usuarioR").addClass("is-invalid");
        $("#usuarioR").removeClass("is-valid");
        $("#btnGuardar").prop("disabled", true);//Deshabilitar el boton de guardar
    }

    if (data === "no existe usuario") {
        $("#usuarioR").addClass("is-valid");
        $("#usuarioR").removeClass("is-invalid");
        $("#btnGuardar").prop("disabled", false);//Habilitar el boton de guardar
    } 

  
});

     
});


//================================================================//

//Funcion guardar formulario
function guardaryeditar(e) {


  e.preventDefault(); // No se activará la acción predeterminada del evento
  $("#btnGuardar").prop("disabled", true);

  var formData = new FormData($("#formularioREG_EDIT")[0]);

$.ajax({
    url: "../../ajax/administrador/usuarios.php?op=guardaryeditar&r=" + new Date().getTime(),
    type: "POST",
    data: formData,
    contentType: false,
    processData: false,
    success: function(data) {
        Swal.fire({
            title: 'Resultado',
            text: data,
            icon: 'success',
            showConfirmButton: false,
            timer: 1300 // Tiempo antes de cerrar automáticamente
        }).then(() => {
            location.reload(); // Recargar la página
        });
    },
    error: function() {
        loadingDialog.close(); // Cerrar el diálogo de loading
        Swal.fire({
            title: 'Error',
            text: "Error en la petición.",
            icon: 'error',
            confirmButtonText: 'Aceptar'
        });
    }
});
}

//================================================================//
//Función mostrar u ocultar tabla (datatable)
function mostrartable(flag)
{
  //limpiar();
  limpiarFormReg();
  if (flag)
  {
  $("#tabla").show();//mostrar tabla
  }
  else
  {
  $("#tabla").hide();//ocultar tabla
  }
}

//================================================================//

//mostrar los datos en el formulario (EDITAR)
function mostrar(id_usuario) {
    $.post("../../ajax/administrador/usuarios.php?op=mostrar&r=" + new Date().getTime(), {
        id_usuario: id_usuario
    }, function(data, status) {
        // Recibir la respuesta del ajax
        var data = JSON.parse(data);
        
        //================================================================//
        // Entrando al formulario desde (el botón btnEditar en el AJAX)
        mostrarform(true); // Mostrar formulario
        $("#titleLabel").text("Nueva contraseña (opcional)");
        $("#statusdiv").show(); // Mostrar el campo status
        
        //================================================================//

        // Rellenar los campos del formulario con los datos que se van a editar
        $("#id_usuario").val(data.id);
        $("#statusR").val(data.status);
        $("#nombreR").val(data.nombre);
        $("#apellidoR").val(data.apellido);
        $("#correoR").val(data.correo);
        $("#telefonoR").val(data.telefono);
        $("#tipo_usuarioR").val(data.id_tipo);
        //$("#passwordR").val(data.password); // Si deseas mostrar la contraseña
        $("#usuarioR").val(data.usuario);
        // $('#cedulaR').attr('readonly', true);

        // Desactivar el atributo required en el campo de contraseña
        $("#passwordR").removeAttr('required');

        // Imprimir la respuesta del ajax
        // bootbox.alert(data);
        // return;
    });
}


//================================================================//

//funcion eliminar (metodo seguro)
function eliminar(id_usuario) {

    Swal.fire({
        title: '¡Atención!',
        text: '¿Realmente está seguro de eliminar este registro?',
        icon: 'error',
        showCancelButton: true,
        confirmButtonText: 'Sí, eliminar',
        cancelButtonText: '<i class="fa fa-arrow-circle-left"></i> Cancelar',
        customClass:{
            confirmButton: 'btn btn-primary',
            cancelButton: 'btn btn-danger'
        }
    }).then((result1) => {
        if (result1.value) {

            $.post("../../ajax/administrador/usuarios.php?op=eliminar&r=" + new Date().getTime(), {
                id_usuario: id_usuario

            }).done(function(data) {
                Swal.fire({
                    title: 'Resultado',
                    text: data,
                    icon: 'success',
                    showConfirmButton: false,
                    timer: 1300 // Tiempo antes de cerrar automáticamente

                }).then(() => {
                    location.reload(); // Recargar la página
                });
            })

        } else {
        //else de result1
        }
    });
}

//================================================================//
//Icono eye
const iconEye = document.querySelector(".fa-eye");

iconEye.addEventListener("click", function(){

const icon = this.querySelector("span");

    if (this.nextElementSibling.type === "password") {
        this.nextElementSibling.type = "text";
        icon.classList.remove("fa-eye-slash");
        icon.classList.add('fa-eye');
    }else{
        this.nextElementSibling.type = "password";
        icon.classList.remove("fa-eye");
        icon.classList.add("fa-eye-slash");
    }
});
//================================================================//

init();