// Función que se ejecuta al inicio
function init() {
 
  

      $("#formulario_cambio_clave").on("submit",function(e)
    {
        e.preventDefault(); //Evita el envío del formulario por defecto
        cambio_clave(e);  
    });


}

function cambio_clave(e) {
    e.preventDefault(); // No se activará la acción predeterminada del evento

    var claveNueva = document.getElementById("clave_nueva").value.trim(); // Obtener el valor de la nueva clave
    var repitaClave = document.getElementById("password").value.trim(); // Obtener el valor de la repetición de clave

    // Validar que no estén vacíos
    if (claveNueva === "" || repitaClave === "") {
        Swal.fire({
            icon: 'warning',
            title: 'Advertencia',
            text: 'Por favor, complete ambos campos de la nueva contraseña'
        });
        return false; // Previene el envío del formulario
    }

    if (claveNueva !== repitaClave) {
        Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'Las contraseñas no coinciden'
        });
        return false; // Previene el envío del formulario
    }

    var formData = new FormData($("#formulario_cambio_clave")[0]);
    $.ajax({
    url: "../../ajax/administrador/usuarios.php?op=cambio_clave&r=" + new Date().getTime(),
    type: "POST",
    data: formData,
    contentType: false,
    processData: false,

    success: function(datos) {
        // Verificar si la respuesta es un mensaje de error o éxito
        if (datos === "Clave Actual Incorrecta") {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: datos,
                showConfirmButton: true
            });
        } else {
            Swal.fire({
                icon: 'success',
                title: 'Éxito',
                showConfirmButton: false,
                text: 'Clave actualizada correctamente.'
            });

            // Recargar página luego de 1 segundo
            setTimeout(function() {
                location.reload();
            }, 1300);
        }
    }
});

}



//================================================================//
const eyeOn0 = document.getElementById("eyeOn0");
const eyeOn1 = document.getElementById("eyeOn1");
const eyeOn2 = document.getElementById("eyeOn2");

eyeOn0.addEventListener("click", function() {
    const input = document.getElementById("clave_actual");
    togglePasswordVisibility(input, this);
});

eyeOn1.addEventListener("click", function() {
    const input = document.getElementById("clave_nueva");
    togglePasswordVisibility(input, this);
});

eyeOn2.addEventListener("click", function() {
    const input = document.getElementById("password");
    togglePasswordVisibility(input, this);
});

function togglePasswordVisibility(input, icon) {
    if (input.type === "password") {
        input.type = "text";
        icon.querySelector(".fa-eye").classList.remove("fa-eye");
        icon.querySelector(".fa-eye-content").classList.add("fa-eye-slash");
    } else {
        input.type = "password";
        icon.querySelector(".fa-eye").classList.add("fa-eye");
        icon.querySelector(".fa-eye-slash").classList.remove("fa-eye-slash");
    }
}


init();