function init() {
    // Oculta el botón
    $("#anuncio-btn").hide(); // Esto oculta el botón

    listaractivo();

    $("#formularioREG_EDIT").on("submit", function(e) {
        e.preventDefault(); // Evita el envío del formulario por defecto
        guardaryeditar(e);
    });

    

        

    //================================================================//
    getNumerosAll();
    //================================================================//
}



function getNumeros() {
    $.ajax({
        url: '../../ajax/administrador/administrador.php?op=listarnumeroscantados&r=' + new Date().getTime(),
        method: "GET",
        dataType: "json",
        success: function(numeros) {
            if (numeros.length > 0) {
                numeros.forEach(function(numero) {
                    var existingId = $('#contenedorbolas').find('.bola[data-id="' + numero[1] + '"]');

                    if (existingId.length === 0) {
                          // Crea el HTML para la bola con la imagen
                        var bolaHtml = '<div class="bola slide-in" data-id="' + numero[1] + '">' +
                                       '<img src="../../images/' + numero[2] + numero[0] + '.png" /> ' +
                                       '</div>';
                        $('#contenedorbolas').append(bolaHtml);
                    }
                });
            }
        }
    });
}

function getNumerosAll() {
    $.ajax({
        url: '../../ajax/administrador/administrador.php?op=listartodoslosnumeroscantados&r=' + new Date().getTime(),
        method: "GET",
        dataType: "json",
        success: function(numeros) {
            if (numeros.length > 0) {
                numeros.forEach(function(numero) {
                    var existingId = $('#contenedorbolas').find('.bola[data-id="' + numero[1] + '"]');

                    if (existingId.length === 0) {
                        $('#contenedorbolas').append('<div class="bola slide-in" data-id="' + numero[1] + '">' +
                                       '<img src="../../images/' + numero[2] + numero[0] + '.png" /> ' +
                                       '</div>');
                    }
                });
            }
        }
    });
}

        // Comprobación cada 5 segundos
setInterval(getNumeros, 3000);

function actualizarVideo(nuevaId) {
    var nuevaUrl = "https://www.youtube.com/embed/" + nuevaId;
    var iframe = document.createElement('iframe');
    iframe.video_url = "myVideo";
    iframe.src = nuevaUrl;
    iframe.title = "YouTube video player";
    iframe.frameborder = "0";
    iframe.allowfullscreen = true;

    // Agrega el iframe a un contenedor en tu HTML
    var contenedor = document.getElementById("contenedorVideo"); // Reemplaza con el ID de tu contenedor
    contenedor.appendChild(iframe);
}

// Llamada inicial para obtener la URL y actualizar el video
$(document).ready(function() {
    $.ajax({
        url: '../../ajax/jugador/jugador.php?op=obtenerultimaurl&r=' + new Date().getTime(),
        type: "POST",
        dataType: "json",
        success: function(respuesta) {
           
            actualizarVideo(respuesta.video_url);
        }
    });
});

//Función limpiar (campos especificos en el formulario de busqueda)
function limpiarFormBuscar()
{
  //$("#status").val("");
  $("#escenario").val("").trigger("change");//select 2
  $("#ano").val("");
  $("#descripcion").val("");
  $("#funcionario").val("");
}



//================================================================//
function listarinactivo(busqueda = $('#busquedaCarton').val()) {
    $.ajax({
        url: '../../ajax/jugador/jugador.php?op=listar&busqueda=' + busqueda,
        method: 'GET',
        dataType: 'json',
        success: function(response) {
            $('#tuContenedor').html(response.html);
            $('#pagination').html(response.pagination);
        },
        error: function(xhr, status, error) {
            console.error('Error:', error);
        }
    });
}

$(document).ready(function() {
    listarinactivo(); // Cargar los datos inicialmente
});


function listaractivo() {
    $.ajax({
        url: '../../ajax/jugador/jugador.php?op=listaractivo',
        method: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                $('#tuContenedorElegido').html(response.html);
            } else {
                console.error('Error al cargar los datos: ', response.message || 'No se pudo cargar el contenido');
            }
        },
        error: function(xhr, status, error) {
            console.error('Error en la solicitud:', error);
            console.error('Detalles:', xhr.responseText);
        }
    });
}


function marcar(id_numero) {
    $.post("../../ajax/jugador/jugador.php?op=marcado&r=" + new Date().getTime(), {
        id_numero: id_numero
    }, function(response) {
        // Al recibir respuesta del servidor
        if (response.trim() === "Numero marcado") {
            // Cambiar el color del botón a exito
            $('#btn-' + id_numero).removeClass('btn-default').addClass('btn-success');
        } else if (response.trim() === "Numero desmarcado") {
            // Cambiar el color del botón a secundario
            $('#btn-' + id_numero).removeClass('btn-success').addClass('btn-default');
        } else {
            alert('No se pudo marcar el número.');
        }
    });
}



function elegirCarton(cartonId, id_usuario) {
    $.ajax({
        url: '../../ajax/jugador/jugador.php?op=elegir',
        type: 'POST',
        data: { cartonId: cartonId, id_usuario: id_usuario },
        success: function(data) {
            // Comprobar el mensaje devuelto
            if (data === 'Carton Elegido Correctamente') {
                Swal.fire({
                    title: 'Resultado',
                    text: data,
                    icon: 'success',
                    showConfirmButton: false,
                    timer: 1300 // Tiempo antes de cerrar automáticamente
                }).then(() => {
                    location.reload(); // Recargar la página
                });
            } else if (data === 'ERROR: Debes comprar este carton para esta partida') {
                Swal.fire({
                    title: 'Error',
                    text: data,
                    icon: 'error',
                    confirmButtonText: 'Aceptar'
                });
            } else {
                // Si se reciben otros mensajes que no se hayan considerado
                Swal.fire({
                    title: 'Resultado',
                    text: data,
                    icon: 'info',
                    confirmButtonText: 'Aceptar'
                });
            }
        },
        error: function(xhr, status, error) {
            Swal.fire({
                title: 'Error',
                text: "Error en la petición.",
                icon: 'error',
                confirmButtonText: 'Aceptar'
            });
        }
    });
}


function eliminarcarton(cartonId, id_usuario) {
    Swal.fire({
        title: '¿Estás seguro?',
        text: '¿Realmente deseas eliminar este cartón?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Sí, eliminarlo',
        cancelButtonText: 'No, cancelar'
    }).then((result) => {
        if (result.value) {
            // Si el usuario confirma, realiza la solicitud AJAX
            $.ajax({
                url: '../../ajax/jugador/jugador.php?op=eliminarcarton',
                type: 'POST', // Cambia a 'POST'
                data: { cartonId: cartonId, id_usuario: id_usuario },
                success: function(data) {
                    Swal.fire({
                        title: 'Resultado',
                        text: data,
                        icon: 'success',
                        showConfirmButton: false,
                        timer: 1300 // Tiempo antes de cerrar automáticamente
                    }).then(() => {
                        location.reload(); // Recargar la página
                    });
                },
                error: function(xhr, status, error) {
                    Swal.fire({
                        title: 'Error',
                        text: "Error en la petición.",
                        icon: 'error',
                        confirmButtonText: 'Aceptar'
                    });
                }
            });
        }
    });
}




//================================================================//

function Cancelarform()
{
  //limpiar();
  limpiarFormReg();
  mostrarform(false);//ocultar formulario registro
  mostrartable(true);
}

//================================================================//



//================================================================//
//Función mostrar u ocultar tabla (datatable)
function mostrartable(flag)
{
  //limpiar();
  limpiarFormReg();
  if (flag)
  {
  $("#tabla").show();//mostrar tabla
}
else
{
  $("#tabla").hide();//ocultar tabla
}
}





init();